module

public import Lean.Elab.Command

open Lean Elab Command

/-- An attribute loaded in the ordinary way. -/
syntax (name := regular_attr) "regular_attr" : attr

def addRegular : Name → Syntax → AttributeKind → AttrM Unit := fun _ stx _ => do
  logInfo m!"input syntax: {format stx}"
  match stx with
  | `(attr| regular_attr) => logInfo "regular attr success!"
  | stx => logInfo m!"failed to match; regular attr stx detail:\n{repr stx}"

/-- From an imported module. -/
initialize registerBuiltinAttribute {
  name := `regular_attr
  descr := "Regular"
  add := addRegular
}

def hello := "world"
