module

public import Lean.Elab.Command
import Batteries -- comment out for `lake build` to work

open Lean Elab Command

/-- An attribute defined in a plugin. -/
syntax (name := plugin_attr) "plugin_attr"  : attr

def addPlugin : Name → Syntax → AttributeKind → AttrM Unit := fun _ stx _ => do
  logInfo m!"input syntax: {format stx}"
  match stx with
  | `(attr| plugin_attr) => logInfo "plugin attr success!"
  | stx => logInfo m!"failed to match; plugin attr stx detail:\n{repr stx}"


/-- From the plugin. -/
initialize registerBuiltinAttribute {
  name := `plugin_attr
  descr := "Regular"
  add := addPlugin
}

-- initialize addLinter { run := fun stx => logInfo m!"@({stx}): plugin working!" }
