import Mathlib.Analysis.SpecialFunctions.Pow.Real
import Mathlib.Topology.Algebra.InfiniteSum
import Mathlib.Data.Complex.Basic

open Complex Topology

namespace RiemannZeta

noncomputable def zeta_series (s : ℂ) : ℂ :=
  ∑' n : ℕ+, 1 / (n : ℂ) ^ s

/-- La serie de Riemann converge absolutamente para Re(s) > 1 -/
lemma zeta_series_converges (s : ℂ) (h : 1 < s.re) :
  Summable (λ n : ℕ+, 1 / (n : ℂ) ^ s) := by
  -- Usamos que |n^(-s)| = n^(-Re(s))
  apply summable_of_norm_bounded
  use (λ n : ℕ+, 1 / (n : ℝ) ^ s.re)
  constructor
  · intro n
    simp only [Complex.norm_eq_abs, Complex.abs_cpow_eq_rpow_re_of_pos (Nat.cast_pos.mpr n.2)]
  · apply Real.summable_inv_rpow
    linarith
open Filter Topology

/-- `zeta_series` es continua en {s ∈ ℂ | Re(s) > 1} -/
lemma zeta_series_continuous (s : ℂ) (h : 1 < s.re) :
  ContinuousAt zeta_series s := by
  apply ContinuousAt.tsum
  intro n
  apply ContinuousAt.div_const
  exact continuousAt_cpow_const (of_real_pos.mpr (Nat.cast_pos.mpr n.2)) _

/-- `zeta_series` es holomorfa (compleja diferenciable) en {s ∈ ℂ | Re(s) > 1} -/
lemma zeta_series_holomorphic (s : ℂ) (h : 1 < s.re) :
  HasDerivAt zeta_series
    (∑' n : ℕ+, -Complex.log n * (1 : ℂ) / (n : ℂ) ^ s) s := by
  apply hasDerivAt_tsum
  intro n
  apply (Complex.hasDerivAt_cpow_const _ (of_real_pos.mpr (Nat.cast_pos.mpr n.2))).neg.mul_const

end RiemannZeta

